package com.inet.samples.formula;

import com.inet.logging.LogManager;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;

/**
 * Server plugin which registers some userdefined formulas.
 */
@PluginInfo( //
id = "customformulas",// 
dependencies = "reporting", //
flags = "designer", //
group = "samples", //
version = "25.10.198", //
icon = "com/inet/samples/formula/cust_formula_48.png" //
)
public class UserdefinedFormulaPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        try {
            spm.register( UserDefinedFunction.class, new FormulaSample() );
        } catch( Exception ex ) {
            LogManager.getConfigLogger().error( ex );
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
